﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business.App" %>
<%@ Import Namespace="Soneta.Business.Db" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Core.GIODO" %>
<%@ Import Namespace="Soneta.Core.UI.GIODO" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Rejestr czynności przetwarzania</title>
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">

    <script runat="server">

        void OnContextLoad(Object sender, EventArgs args)
        {
            var title = "Odwołanie upoważnienia|";
            GIODOUprawnienie uprawnienie = (GIODOUprawnienie)dc[typeof(GIODOUprawnienie)];
	        if (uprawnienie.Odebrane == Date.Empty || uprawnienie.Odebrane == Date.MaxValue)
		        throw new Exception(string.Format("Upoważnienie {0} nie zostało odwołane.", uprawnienie.Numer));

            title += "</STRONG>Dokument:<STRONG> " + uprawnienie.Numer.NumerPelny + ",|";
            title += "</STRONG>Data odwołania:<STRONG> " + uprawnienie.Odebrane.ToString("dd.MM.yyyy");
            ReportHeader.Title = title;
            Nazwa.EditValue = uprawnienie.Uprawniony.Nazwa;
            Tresc.EditValue = uprawnienie.Definicja.Tresc;
            TrescOpis.Visible = string.IsNullOrEmpty(uprawnienie.Definicja.Tresc.ToString());

            stPodpis.Caption = "<font size=1>Dokument wystawił: </font><font size=2>"+""+"</font><br><br><br><font size=1>..................................................<br>Podpis</font>";
            stOsoba.Caption = "<font size=1>Dokument otrzymał: </font><font size=2>"+""+"</font><br><br><br><font size=1>..................................................<br>Podpis</font>";
        }

    </script>

</head>
<body>
    <form method="post" runat="server">
        <ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
        <eb:ReportHeader id="ReportHeader" runat="server" title="Zgoda na przetwarzanie danych"></eb:ReportHeader>

        <table id="Table1" cellspacing="0" cellpadding="1" width="100%" border="0" style="font-family: Tahoma, Arial; margin-top: 20px; margin-bottom: 30px; ">
            <tr>
                <td style="text-align: center;">
                    <br />
                    <b>Odwołanie upoważnienia do przetwarzania danych osobowych</b>
                </td>
            </tr>
            <tr>
                <td style="">
                    <br />
                    Na podstawie art.37 ustawy z dnia 29.08.1997 r. o ochronie danych osobowych (Dz. U. 2015 r. poz 2135) Pan/Pani:
                </td>
            </tr>
            <tr>
                <td style="text-align: center;">
                    <br />
                    <ea:datalabel runat="server" id="Nazwa" encodehtml="true" ></ea:datalabel>
                </td>
            </tr>
            <tr>
                <td style="">
                    <br />
                    traci upoważnienie do przetwarzania danych osobowych w następującym zakresie:
                </td>
            </tr>
            <tr>
                <td style="">
                    <br />
                    <ea:datalabel runat="server" id="Tresc" Bold="false"  encodehtml="true"></ea:datalabel>
                </td>
            </tr>
            <tr>
                <ea:Section ID="TrescOpis" runat="server">
                    <td style="text-align: left;">
                        <br />
                        ...........................................................................................................................................<br />
                        ...........................................................................................................................................<br />
                        ...........................................................................................................................................<br />
                    </td>
                </ea:Section>
            </tr>
            <tr>
                <td style="text-align: justify;">
                    <br />
                    Odwoływane upoważnienie uprawnia do przeglądania, zapisywania, modyfikowania oraz odczytywania danych osobowych na zasadach określonych w polityce bezpieczeństwa danych osobowych.
                    <br />
                    <br />
                    Upoważniony oświadcza, że zapoznał sie z polityką bezpieczeństa danych osobowych w organizacji. Upoważniony przyjmuje do wiadomości, iż na podstawie art. 39 ust. 2 ustawy o ochronie danych osobowych ma obowiązek zachować w tajemnicy dane osobowe, do których przetwarzania został upoważniony oraz sposoby ich zabezpieczania, zarówno w okresie ważności upoważnienia, jak i po jego wygaśnięciu.
                    <br />
                    <br />
                    Upoważniony oświadcza, iż jest świadomy odpowiedzialności karnej za naruszenie zasad przetwarzania danych osobowych określonej w rozdziale 8 ustawy o ochronie danych osobowych.
                </td>
            </tr>
        </table>

        <eb:ReportFooter id="ReportFooter" runat="server">
            <subtitles>
                <eb:FooterSubtitle runat="server" Caption="Operator" ID="stPodpis" SubtitleType="CenterText" Width="50"></eb:FooterSubtitle>
                <eb:FooterSubtitle runat="server" Caption="Osoba" ID="stOsoba" SubtitleType="CenterText" Width="50"></eb:FooterSubtitle>
          </subtitles>
        </eb:ReportFooter>
    </form>
</body>
</html>
